'use client';

import { useState, useEffect } from 'react';
import Header from '../../../components/Header';
import MobileHeader from '../../../components/MobileHeader';
import Footer from '../../../components/Footer';
import DraggableSlider from '../../../components/DraggableSlider';
import CounterAnimation from '../../../components/CounterAnimation';
import ImageModal from '../../../components/ImageModal';
import { useTranslations } from 'next-intl';
import Image from 'next/image';
import PartnersSection from '../../../components/PartnersSection';
import AnimatedText from '../../../components/AnimatedText';
import AnimatedElement from '../../../components/AnimatedElement';
import Link from 'next/link';
import InvestmentForm from '../../../components/InvestmentForm';
import InvestmentFormMobile from '../../../components/InvestmentFormMobile';

export default function InvestorsPage() {
  const t = useTranslations('InvestorsPage');
  const tCommon = useTranslations('Common');
  const [modalImage, setModalImage] = useState<{src: string, alt: string} | null>(null);
  const [isDesktop, setIsDesktop] = useState(false);

  useEffect(() => {
    const checkScreenSize = () => {
      setIsDesktop(window.innerWidth >= 1024);
    };

    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);

    return () => window.removeEventListener('resize', checkScreenSize);
  }, []);

  const openModal = (src: string, alt: string) => {
    setModalImage({ src, alt });
  };

  const closeModal = () => {
    setModalImage(null);
  };

  const scrollToForm = () => {
    let attempts = 0;
    function tryScroll() {
      const formSection = document.querySelector('[data-section="investment-form"]');
      if (formSection) {
        console.log('scrollToForm: элемент найден, скроллим');
        formSection.scrollIntoView({ behavior: 'smooth', block: 'start' });
      } else if (attempts < 5) {
        attempts++;
        console.log('scrollToForm: элемент не найден, пробую ещё раз', attempts);
        setTimeout(tryScroll, 200);
      } else {
        console.warn('scrollToForm: не удалось найти элемент для скролла');
      }
    }
    tryScroll();
  };

  return (
    <div className="min-h-screen flex flex-col bg-white">
      {isDesktop ? <Header /> : <MobileHeader />}
      
      {/* Panorama Hero Section */}
      <section className="relative flex flex-col items-center justify-center h-[720px] overflow-hidden">
        {/* Background Video */}
        <video
          autoPlay
          loop
          muted
          playsInline
          className="absolute inset-0 z-0 object-cover w-full h-full"
        >
          <source src="/images/investors/doc_2025-07-08_01-42-19.mp4" type="video/mp4" />
        </video>
        
        {/* Gradient Overlay */}
        <div className="absolute inset-0 z-10 bg-gradient-to-b from-black/19 to-black/50"></div>
        
        {/* Content */}
        <div className={`relative z-20 flex flex-col items-start justify-between w-full h-full ${isDesktop ? 'max-w-[1376px] p-8' : 'w-full p-3'}`}>
          <AnimatedText
            as="div"
            animation="slideInUp"
            delay={200}
            className="w-full text-center text-white font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
          >
            {t('hero_title')}
          </AnimatedText>
          <AnimatedText
            as="div"
            animation="slideInUp"
            delay={400}
            className="w-full text-white font-roboto text-2xl font-light leading-[130%]"
          >
            {t('hero_subtitle')}
          </AnimatedText>
        </div>
      </section>

      {/* Investment Features Section */}
      <section className="flex py-[60px] px-3 flex-col justify-center items-center gap-[60px] w-full bg-[#F5F1F0]">
        <div className={`flex ${isDesktop ? 'max-w-[1376px]' : 'w-full'} flex-col items-start gap-[60px] w-full`}>
          <AnimatedText
            as="h2"
            animation="slideInUp"
            delay={200}
            className="text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px] text-center w-full"
          >
            {t('features_title')}
          </AnimatedText>
          <div className="grid grid-cols-1 md:grid-cols-2 gap-x-24 gap-y-12 w-full">
            {/* Карточка 1 */}
            <AnimatedElement animation="slideInLeft" delay={300} className="flex items-center gap-6 w-full">
              <div style={{ width: 100, height: 100, flexShrink: 0 }}>
                <Image src="/images/investors/Group 1.svg" alt={t('feature1_title')} width={100} height={100} style={{ flexShrink: 0 }} />
              </div>
              <div className="flex flex-col justify-center min-h-[110px]">
                <h3 className="text-[#1C1C1C] font-roboto text-2xl md:text-3xl font-light leading-[130%] mb-1 min-h-[38px] flex items-center">{t('feature1_title')}</h3>
                <p className="text-[#1C1C1C] font-roboto text-base md:text-lg font-light leading-[150%] min-h-[48px] flex items-center">{t('feature1_desc')}</p>
              </div>
            </AnimatedElement>
            {/* Карточка 2 */}
            <AnimatedElement animation="slideInRight" delay={400} className="flex items-center gap-6 w-full">
              <div style={{ width: 100, height: 100, flexShrink: 0 }}>
                <Image src="/images/investors/Group 2.svg" alt={t('feature2_title')} width={100} height={100} style={{ flexShrink: 0 }} />
              </div>
              <div className="flex flex-col justify-center min-h-[110px]">
                <h3 className="text-[#1C1C1C] font-roboto text-2xl md:text-3xl font-light leading-[130%] mb-1 min-h-[38px] flex items-center">{t('feature2_title')}</h3>
                <p className="text-[#1C1C1C] font-roboto text-base md:text-lg font-light leading-[150%] min-h-[48px] flex items-center">{t('feature2_desc')}</p>
              </div>
            </AnimatedElement>
            {/* Карточка 3 */}
            <AnimatedElement animation="slideInLeft" delay={500} className="flex items-center gap-6 w-full">
              <div style={{ width: 100, height: 100, flexShrink: 0 }}>
                <Image src="/images/investors/Group 3.svg" alt={t('feature3_title')} width={100} height={100} style={{ flexShrink: 0 }} />
              </div>
              <div className="flex flex-col justify-center min-h-[110px]">
                <h3 className="text-[#1C1C1C] font-roboto text-2xl md:text-3xl font-light leading-[130%] mb-1 min-h-[38px] flex items-center">{t('feature3_title')}</h3>
                <p className="text-[#1C1C1C] font-roboto text-base md:text-lg font-light leading-[150%] min-h-[48px] flex items-center">{t('feature3_desc')}</p>
              </div>
            </AnimatedElement>
            {/* Карточка 4 */}
            <AnimatedElement animation="slideInRight" delay={600} className="flex items-center gap-6 w-full">
              <div style={{ width: 100, height: 100, flexShrink: 0 }}>
                <Image src="/images/investors/Group 4.svg" alt={t('feature4_title')} width={100} height={100} style={{ flexShrink: 0 }} />
              </div>
              <div className="flex flex-col justify-center min-h-[110px]">
                <h3 className="text-[#1C1C1C] font-roboto text-2xl md:text-3xl font-light leading-[130%] mb-1 min-h-[38px] flex items-center">{t('feature4_title')}</h3>
                <p className="text-[#1C1C1C] font-roboto text-base md:text-lg font-light leading-[150%] min-h-[48px] flex items-center">{t('feature4_desc')}</p>
              </div>
            </AnimatedElement>
            {/* Карточка 5 */}
            <AnimatedElement animation="slideInLeft" delay={700} className="flex items-center gap-6 w-full">
              <div style={{ width: 100, height: 100, flexShrink: 0 }}>
                <Image src="/images/investors/Group 5.svg" alt={t('feature5_title')} width={100} height={100} style={{ flexShrink: 0 }} />
              </div>
              <div className="flex flex-col justify-center min-h-[110px]">
                <h3 className="text-[#1C1C1C] font-roboto text-2xl md:text-3xl font-light leading-[130%] mb-1 min-h-[38px] flex items-center">{t('feature5_title')}</h3>
                <p className="text-[#1C1C1C] font-roboto text-base md:text-lg font-light leading-[150%] min-h-[48px] flex items-center">{t('feature5_desc')}</p>
              </div>
            </AnimatedElement>
            {/* Карточка 6 */}
            <AnimatedElement animation="slideInRight" delay={800} className="flex items-center gap-6 w-full">
              <div style={{ width: 100, height: 100, flexShrink: 0 }}>
                <Image src="/images/investors/Group 6.svg" alt={t('feature6_title')} width={100} height={100} style={{ flexShrink: 0 }} />
              </div>
              <div className="flex flex-col justify-center min-h-[110px]">
                <h3 className="text-[#1C1C1C] font-roboto text-2xl md:text-3xl font-light leading-[130%] mb-1 min-h-[38px] flex items-center">{t('feature6_title')}</h3>
                <p className="text-[#1C1C1C] font-roboto text-base md:text-lg font-light leading-[150%] min-h-[48px] flex items-center">{t('feature6_desc')}</p>
              </div>
            </AnimatedElement>
          </div>
        </div>
      </section>

      {/* Investment Statistics */}
      <section className="flex py-[55px] px-3 flex-col justify-center items-center gap-[29px] w-full bg-[#F5F1F0]">
        <div className={`flex ${isDesktop ? 'max-w-[1376px] items-start gap-[29px]' : 'max-w-[1376px] flex-col items-start gap-[29px]'} w-full`}>
          <AnimatedElement animation="slideInUp" delay={300} className="flex flex-col justify-center items-center gap-2 flex-1">
            <p className="w-full text-[#1C1C1C] text-center font-roboto text-2xl font-light leading-[130%]">
              {t('stats1_title')}
            </p>
            <CounterAnimation
              end={508.9}
              duration={2500}
              suffix="M$"
              decimals={1}
              className="w-full text-[#1C1C1C] text-center font-roboto text-[84px] font-light leading-[115%] tracking-[-2.52px]"
            />
          </AnimatedElement>
          
          <AnimatedElement animation="slideInUp" delay={400} className="flex flex-col justify-center items-center gap-2 flex-1">
            <p 
              className="w-full text-[#1C1C1C] text-center font-roboto text-2xl font-light leading-[130%]"
              dangerouslySetInnerHTML={{ __html: t('stats2_title') }}
            />
            <CounterAnimation
              end={66.64}
              duration={2200}
              suffix="%"
              decimals={2}
              className="w-full text-[#1C1C1C] text-center font-roboto text-[84px] font-light leading-[115%] tracking-[-2.52px]"
            />
          </AnimatedElement>
          
          <AnimatedElement animation="slideInUp" delay={500} className="flex flex-col justify-center items-center gap-2 flex-1">
            <p 
              className="w-full text-[#1C1C1C] text-center font-roboto text-2xl font-light leading-[130%]"
              dangerouslySetInnerHTML={{ __html: t('stats3_title') }}
            />
            <CounterAnimation
              end={400}
              duration={2000}
              suffix="%"
              className="w-full text-[#1C1C1C] text-center font-roboto text-[84px] font-light leading-[115%] tracking-[-2.52px]"
            />
          </AnimatedElement>
          
          <AnimatedElement animation="slideInUp" delay={600} className="flex flex-col justify-center items-center gap-2 flex-1">
            <p className="w-full text-[#1C1C1C] text-center font-roboto text-2xl font-light leading-[130%]">
              {t('stats4_title')}
            </p>
            <CounterAnimation
              end={6}
              duration={1800}
              suffix={` ${t('years')}`}
              className="w-full text-[#1C1C1C] text-center font-roboto text-[84px] font-light leading-[115%] tracking-[-2.52px]"
            />
          </AnimatedElement>
        </div>
      </section>

      {/* LAKE Token Insert Section */}
      <section className="flex h-[480px] py-[150px] px-3 justify-center items-center gap-10 w-full bg-white">
        <div className={`flex ${isDesktop ? 'max-w-[1376px]' : 'w-full'} flex-col items-start gap-10 flex-1`}>
          <div className="flex flex-col items-start gap-3 w-full">
            <AnimatedText
              as="h2"
              animation="slideInUp"
              delay={200}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('token_title')}
            </AnimatedText>
            <AnimatedText
              as="p"
              animation="slideInUp"
              delay={400}
              className="w-full text-[#1C1C1C] font-roboto text-2xl font-light leading-[130%]"
            >
              {t('token_subtitle')}
            </AnimatedText>
          </div>
          <AnimatedElement animation="slideInUp" delay={600} className="flex py-3 px-6 justify-center items-center gap-2 rounded-sm bg-[#A79D94]">
            <Link href={'/lake-token'} className="flex justify-center items-center gap-2 w-full h-full">
              <span className="text-white font-roboto text-lg font-normal leading-[150%]">
                {tCommon('lake_token')}
              </span>
            </Link>
          </AnimatedElement>
        </div>
      </section>

      {/* Investment Access Form Section */}
      {isDesktop ? (
        <section className="flex py-20 px-3 justify-center items-center gap-[60px] w-full bg-[#F5F1F0]" data-section="investment-form">
          <div className="flex w-[1376px] max-w-[1376px] items-center gap-10 w-full">
            <div className="flex flex-col items-start gap-3 flex-1">
              <AnimatedText
                as="h2"
                animation="slideInLeft"
                delay={200}
                className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
              >
                {t('form_title')}
              </AnimatedText>
              <AnimatedText
                as="p"
                animation="slideInLeft"
                delay={400}
                className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
              >
                {t('form_desc1')}
              </AnimatedText>
              <AnimatedText
                as="p"
                animation="slideInLeft"
                delay={600}
                className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
              >
                {t('form_desc2')}
              </AnimatedText>
            </div>
            
            <AnimatedElement animation="slideInRight" delay={300} className="flex flex-col justify-center items-center gap-6 flex-1">
              <InvestmentForm />
            </AnimatedElement>
          </div>
        </section>
      ) : (
        // Мобильная версия согласно JSON дизайну
        <section className="flex h-[915px] py-20 px-3 justify-center items-center w-full bg-[#F5F1F0]" data-section="investment-form">
          <div className="flex max-w-[1376px] flex-col items-start gap-10 w-full">
            <div className="flex flex-col items-start gap-3 w-full">
              <AnimatedText
                as="h2"
                animation="slideInUp"
                delay={200}
                className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
              >
                {t('form_title')}
              </AnimatedText>
              <AnimatedText
                as="p"
                animation="slideInUp"
                delay={400}
                className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
              >
                {t('form_desc1')}
              </AnimatedText>
              <AnimatedText
                as="p"
                animation="slideInUp"
                delay={600}
                className="w-full text-[#1C1C1C] font-roboto text-lg font-light leading-[150%]"
              >
                {t('form_desc2')}
              </AnimatedText>
            </div>
            
            <AnimatedElement animation="slideInUp" delay={300} className="flex flex-col justify-center items-center gap-6 w-full">
              <InvestmentFormMobile />
            </AnimatedElement>
          </div>
        </section>
      )}

      {/* Investment Dossier Section */}
      {isDesktop ? (
        <section className="flex py-[60px] px-3 flex-col justify-center items-center gap-10 w-full bg-white">
          <div className="flex max-w-[1376px] flex-col items-start gap-10 w-full">
            <AnimatedText
              as="h2"
              animation="slideInUp"
              delay={200}
              className="w-full text-[#1C1C1C] text-center font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('dossier_title')}
            </AnimatedText>
            <div className="flex items-center gap-10 w-full">
              <AnimatedElement animation="slideInLeft" delay={300} className="flex h-[378px] pr-6 items-start gap-2 flex-1 cursor-pointer hover:scale-105 transition-transform duration-300">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview.png" 
                    alt="Investment Dossier Preview 1"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={378}
                    height={378}
                  />
                </div>
              </AnimatedElement>
              <AnimatedElement animation="slideInRight" delay={400} className="flex h-[378px] pr-6 items-start gap-2 flex-1 cursor-pointer hover:scale-105 transition-transform duration-300">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview2.png" 
                    alt="Investment Dossier Preview 2"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={378}
                    height={378}
                  />
                </div>
              </AnimatedElement>
            </div>
            <div className="flex items-center gap-10 w-full">
              <AnimatedElement animation="slideInLeft" delay={500} className="flex h-[378px] pr-6 items-start gap-2 flex-1 cursor-pointer hover:scale-105 transition-transform duration-300">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview3.png" 
                    alt="Investment Dossier Preview 3"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={378}
                    height={378}
                  />
                </div>
              </AnimatedElement>
              <AnimatedElement animation="slideInRight" delay={600} className="flex h-[378px] pr-6 items-start gap-2 flex-1 cursor-pointer hover:scale-105 transition-transform duration-300">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview4.png" 
                    alt="Investment Dossier Preview 4"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={378}
                    height={378}
                  />
                </div>
              </AnimatedElement>
            </div>
          </div>
        </section>
      ) : (
        // Мобильная версия согласно JSON дизайну
        <section className="flex h-[1166px] py-[60px] px-3 flex-col justify-center items-center gap-10 w-full bg-white">
          <div className="flex max-w-[1376px] flex-col items-start gap-10 w-full">
            <AnimatedText
              as="h2"
              animation="slideInUp"
              delay={200}
              className="w-full text-[#1C1C1C] text-center font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('dossier_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-10 w-full">
              <AnimatedElement animation="slideInUp" delay={300} className="flex h-[198.62px] pr-3 items-start gap-1 w-full cursor-pointer hover:scale-105 transition-transform duration-300">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview.png" 
                    alt="Investment Dossier Preview 1"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={375}
                    height={199}
                  />
                </div>
              </AnimatedElement>
              <AnimatedElement animation="slideInUp" delay={400} className="flex h-[198.62px] pr-3 items-start gap-1 w-full cursor-pointer hover:scale-105 transition-transform duration-300">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview2.png" 
                    alt="Investment Dossier Preview 2"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={375}
                    height={199}
                  />
                </div>
              </AnimatedElement>
            </div>
            <div className="flex flex-col justify-center items-start gap-10 w-full">
              <AnimatedElement animation="slideInUp" delay={500} className="flex h-[198.62px] pr-3 items-start gap-1 w-full cursor-pointer hover:scale-105 transition-transform duration-300">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview3.png" 
                    alt="Investment Dossier Preview 3"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={375}
                    height={199}
                  />
                </div>
              </AnimatedElement>
              <AnimatedElement animation="slideInUp" delay={600} className="flex h-[198.62px] pr-3 items-start gap-1 w-full cursor-pointer hover:scale-105 transition-transform duration-300">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview4.png" 
                    alt="Investment Dossier Preview 4"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={375}
                    height={199}
                  />
                </div>
              </AnimatedElement>
            </div>
          </div>
        </section>
      )}

      {/* Licenses Section */}
      <section className="flex py-[60px] px-3 flex-col justify-center items-center gap-10 w-full bg-[#F5F1F0]">
        <div className={`flex w-full flex-col items-center gap-10 ${isDesktop ? 'max-w-[1200px]' : 'max-w-[1376px]'}`}>
          <AnimatedText
            as="h2"
            animation="slideInUp"
            delay={200}
            className="w-full text-[#1C1C1C] text-center font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
          >
            {t('licenses_title')}
          </AnimatedText>
          <div className={`flex ${isDesktop ? 'items-center justify-center gap-10' : 'flex-col justify-center items-start gap-10'}`}>
            <AnimatedElement animation="slideInLeft" delay={300} className={`${isDesktop ? 'w-[297.5px] h-[421px]' : 'w-full h-[421px]'} cursor-pointer hover:scale-105 transition-transform duration-300 block`}>
              <Image 
                src="/images/investors/Licenses/4d2a1ccd327582ecfc4a72a23b8d927649744104.jpg" 
                alt="License Document 1"
                className="w-full h-full object-cover rounded-lg shadow-lg"
                width={297.5}
                height={421}
              />
            </AnimatedElement>
            <AnimatedElement animation="slideInUp" delay={400} className={`${isDesktop ? 'w-[297.5px] h-[421px]' : 'w-full h-[421px]'} cursor-pointer hover:scale-105 transition-transform duration-300 block`}>
              <Image 
                src="/images/investors/Licenses/5aec82f0fc920ab66b7bc3cb0d9ce18c04350538.png" 
                alt="License Document 2"
                className="w-full h-full object-cover rounded-lg shadow-lg"
                width={297.5}
                height={421}
              />
            </AnimatedElement>
            <AnimatedElement animation="slideInRight" delay={500} className={`${isDesktop ? 'w-[297.5px] h-[421px]' : 'w-full h-[421px]'} cursor-pointer hover:scale-105 transition-transform duration-300 block`}>
              <Image 
                src="/images/investors/Licenses/8bcb8a64afbc5813b160c7c883c475abf4782556.png" 
                alt="License Document 3"
                className="w-full h-full object-cover rounded-lg shadow-lg"
                width={297.5}
                height={421}
              />
            </AnimatedElement>
          </div>
        </div>
      </section>

      {/* Partners Section */}
      <PartnersSection />

      {/* Investor Q&A Section */}
      {isDesktop ? (
        <section className="flex py-[60px] px-3 flex-col justify-center items-center gap-10 w-full bg-white">
          <div className="flex max-w-[1376px] flex-col items-start gap-10 w-full">
            <AnimatedText
              as="h2"
              animation="slideInUp"
              delay={200}
              className="w-full text-[#1C1C1C] text-center font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('qa_title')}
            </AnimatedText>
            <div className="flex items-center gap-10 w-full">
              <AnimatedElement animation="slideInLeft" delay={300} className="flex h-[378px] pr-6 items-start gap-2 flex-1 cursor-pointer hover:scale-105 transition-transform duration-300 text-left">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview.png" 
                    alt="Investor Q&A Preview 1"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={378}
                    height={378}
                  />
                </div>
              </AnimatedElement>
              <AnimatedElement animation="slideInRight" delay={400} className="flex h-[378px] pr-6 items-start gap-2 flex-1 cursor-pointer hover:scale-105 transition-transform duration-300 text-left">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview2.png" 
                    alt="Investor Q&A Preview 2"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={378}
                    height={378}
                  />
                </div>
              </AnimatedElement>
            </div>
            <div className="flex items-center gap-10 w-full">
              <AnimatedElement animation="slideInLeft" delay={500} className="flex h-[378px] pr-6 items-start gap-2 flex-1 cursor-pointer hover:scale-105 transition-transform duration-300 text-left">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview3.png" 
                    alt="Investor Q&A Preview 3"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={378}
                    height={378}
                  />
                </div>
              </AnimatedElement>
              <AnimatedElement animation="slideInRight" delay={600} className="flex h-[378px] pr-6 items-start gap-2 flex-1 cursor-pointer hover:scale-105 transition-transform duration-300 text-left">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview4.png" 
                    alt="Investor Q&A Preview 4"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={378}
                    height={378}
                  />
                </div>
              </AnimatedElement>
            </div>
          </div>
        </section>
      ) : (
        // Мобильная версия согласно JSON дизайну
        <section className="flex py-[60px] px-3 flex-col justify-center items-center gap-10 w-full bg-white">
          <div className="flex max-w-[1376px] flex-col items-start gap-10 w-full">
            <AnimatedText
              as="h2"
              animation="slideInUp"
              delay={200}
              className="w-full text-[#1C1C1C] text-center font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('qa_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-10 w-full">
              <AnimatedElement animation="slideInUp" delay={300} className="flex h-[198.62px] pr-3 items-start gap-1 w-full cursor-pointer hover:scale-105 transition-transform duration-300 text-left">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview.png" 
                    alt="Investor Q&A Preview 1"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={375}
                    height={199}
                  />
                </div>
              </AnimatedElement>
              <AnimatedElement animation="slideInUp" delay={400} className="flex h-[198.62px] pr-3 items-start gap-1 w-full cursor-pointer hover:scale-105 transition-transform duration-300 text-left">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview2.png" 
                    alt="Investor Q&A Preview 2"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={375}
                    height={199}
                  />
                </div>
              </AnimatedElement>
            </div>
            <div className="flex flex-col justify-center items-start gap-10 w-full">
              <AnimatedElement animation="slideInUp" delay={500} className="flex h-[198.62px] pr-3 items-start gap-1 w-full cursor-pointer hover:scale-105 transition-transform duration-300 text-left">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview3.png" 
                    alt="Investor Q&A Preview 3"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={375}
                    height={199}
                  />
                </div>
              </AnimatedElement>
              <AnimatedElement animation="slideInUp" delay={600} className="flex h-[198.62px] pr-3 items-start gap-1 w-full cursor-pointer hover:scale-105 transition-transform duration-300 text-left">
                <div onClick={scrollToForm} style={{width: '100%', height: '100%', cursor: 'pointer'}}>
                  <Image 
                    src="/images/investors/Investment Dossier/preview4.png" 
                    alt="Investor Q&A Preview 4"
                    className="w-full h-full object-cover rounded-lg shadow-lg"
                    width={375}
                    height={199}
                  />
                </div>
              </AnimatedElement>
            </div>
          </div>
        </section>
      )}

      <Footer />
      
      {/* Image Modal */}
      {modalImage && (
        <ImageModal
          src={modalImage.src}
          alt={modalImage.alt}
          onClose={closeModal}
        />
      )}
    </div>
  );
} 